#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
//#include "ctrl/BOLTReport.h"

#include "BOLTFrm.h"
#include "ctrl/BOLTPictures.h"
#include <wx/mstream.h>

bcPicture::bcPicture(BOLTdb *db,
				const char *table,
				RECORD_ID recordId,
				RECORD_ID imageId):wxImage()
{
	this->db=db;
	this->table=table;
	this->recordId=recordId;
	if( imageId==-1)
	{
		this->imageId=db->NewRecord(table); 
		db->SetValue(table,"parentId",this->imageId,recordId);
	}
	else 
	{ this->imageId=imageId; }
};

bcPicture::bcPicture():wxImage()
{
this->db=NULL;
this->imageId=0;
};


bool bcPicture::LoadFromDatabase()
{
	void *data;
	unsigned long size;
	if (!db) { return FALSE; }
	wxString tStr;
	tStr.Printf("select image from %s where id=%u",table.c_str(),imageId);
	db->GetBinaryQueryValue(tStr.c_str(),&data,size);
//memory output stream
	wxMemoryInputStream sIn((const char *)data,size);
	LoadFile(sIn,wxBITMAP_TYPE_JPEG);
	db->freePtr(&data);
	return true;
};

bool bcPicture::LoadFromQueryResults(BOLTdb *qrDb,QRY_ID qry,void *row,int field)
{
	void *data;
	unsigned long size=0;
	this->db=db;
	qrDb->FetchBinaryResults(qry,row,field,&data,&size);
//memory output stream
	wxMemoryInputStream sIn((const char *)data,size);
	LoadFile(sIn,wxBITMAP_TYPE_JPEG);
	db->freePtr(&data);
//	free(data);
	return Ok();

}

bool bcPicture::SaveToDatabase()
{
	wxMemoryOutputStream *sOut;
	sOut=new wxMemoryOutputStream(NULL,0);
	unsigned int size;
	char *buffer;

	if (!db) { safe_delete(sOut); return FALSE; }
	SaveFile(*sOut,wxBITMAP_TYPE_JPEG);
	size=sOut->GetSize();
	//create someplace to hold this
	buffer=(char *)malloc(size);
	if (!buffer) { safe_delete(sOut); return FALSE; }
	//copy to that buffer
	sOut->CopyTo(buffer,size);
	//do it
	db->SetBinaryValue(table.c_str(),"image",imageId,buffer,size);
	safe_delete(sOut);
	free(buffer);
	return true;
};


bcPictureDisplay::bcPictureDisplay(wxWindow *parent,
					BOLTdb *db,
					const char *table,
					RECORD_ID recordId,
					RECORD_ID imageId):wxDialog(parent,-1,"Picture Viewer",wxDefaultPosition,wxDefaultSize,wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER)
{
	bcPicture *img;
	wxBoxSizer *tSizer;
	wxScrolledWindow *sWin;

	img=new bcPicture(db,table,recordId,imageId);
	img->LoadFromDatabase();

	sWin=new wxScrolledWindow(this,-1);
	sWin->SetScrollRate(25,25);
	tSizer=new wxBoxSizer(wxVERTICAL);
	tSizer->Add(new wxStaticBitmap(sWin,-1,img->ConvertToBitmap()),0,wxALIGN_LEFT);
	sWin->SetSizer(tSizer);

	tSizer=new wxBoxSizer(wxVERTICAL);
	tSizer->Add(new wxButton(this,wxID_CANCEL,"&Close"));
	tSizer->Add(sWin,1,wxEXPAND);
	sWin->SetVirtualSize(img->GetWidth(),img->GetHeight());	
	tSizer->SetItemMinSize(sWin,sWin->GetBestSize().x,sWin->GetBestSize().y);
	SetSizerAndFit(tSizer);

	this->CenterOnParent();
	sWin->FitInside();
	
	this->FindWindow(wxID_CANCEL)->SetFocus();
	this->ShowModal();
	safe_delete(img);
};

enum {
	ID_NEW=13455,
		ID_DEL,
		ID_IMG
};

//IMPLEMENT_DYNAMIC_CLASS(bcPictures,wxPanel)
BEGIN_EVENT_TABLE(bcPictures,wxPanel)
EVT_BUTTON(ID_NEW,bcPictures::OnNew)
EVT_BUTTON(ID_DEL,bcPictures::OnDelete)
END_EVENT_TABLE()

bcPictures::bcPictures(wxWindow *parent,
				BOLTdb *db,
				const char *table,
				RECORD_ID recordId):wxPanel(parent,-1)
{
	imCount=0;
	this->db=db;
	SetFont(parent->GetFont());

	this->table=table;
	this->recordId=recordId;
	delMode=false;
	SetBackgroundColour(GetParent()->GetBackgroundColour());

	wxBoxSizer *topSizer=new wxBoxSizer(wxVERTICAL);
	wxBoxSizer *hSizer;

	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(this->bNew=new wxButton(this,ID_NEW,"New"),0,wxALIGN_CENTER|wxALL,5);
	hSizer->Add(this->bDelete=new wxButton(this,ID_DEL,"Delete"),0,wxALIGN_CENTER|wxALL,5);
	topSizer->Add(hSizer);

	wPictures=new wxScrolledWindow(this,-1,wxDefaultPosition,wxDefaultSize,wxVSCROLL);
	this->wPictures->EnableScrolling(TRUE,FALSE);
	wPictures->SetBackgroundColour(GetParent()->GetBackgroundColour());

	sPictures=new wxBoxSizer(wxHORIZONTAL);
//	wPictures->SetAutoLayout(TRUE);
	wPictures->SetSizerAndFit(sPictures);
	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(this->wPictures,1,wxEXPAND|wxALL,1);
	topSizer->Add(hSizer,1,wxEXPAND);
	fillPictures();

//	SetAutoLayout(TRUE);
	SetSizer(topSizer);
	//list control
	//notebook
	//fill pages
};

//not used yet
void bcPictures::OnSource(wxCommandEvent & event)
{};

void bcPictures::OnNew(wxCommandEvent & event)
{
	wxString path;
	wxGetApp().frame->Enable(FALSE);
	path=wxFileSelector("Where is the image you would like to use ?","","","jpg","Jpeg Picture|*.jpg",wxOPEN,this->GetParent());
	wxGetApp().frame->Enable(TRUE);
	if (!path.IsEmpty())
	{
		bcPicture *img=new bcPicture(db,table,recordId,-1);
		if (img->LoadFile(path))
		{
			img->SaveToDatabase();
			fillSinglePicture(img->imageId);
			//delete the file
			if(wxMessageBox("Would you like to remove the temporary image file?","Confirm Delete",wxYES_NO,this)==wxYES)
			{
				wxRemoveFile(path);
			}
		} else { 
			//delete from database - empty picture
			path.Printf("delete from %s where id=%u",table,img->imageId);
			db->FreeQuery(db->Query(path.c_str(),path.Length()));
		}
		safe_delete(img);
	}
	SetFocus();
};

void bcPictures::OnActivate(wxCommandEvent &event)
{
	if (delMode)
	{
		wxBitmapButton *button=(wxBitmapButton *)event.GetEventObject();
		this->sPictures->Remove(button);
		wxString tStr;
		tStr.Printf("delete from %s where id=%s",table.c_str(),button->GetName().c_str());
		db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
		delMode=false;
		bDelete->SetLabel("Delete");
		SetBackgroundColour(GetParent()->GetBackgroundColour());
		Refresh(TRUE);
		sPictures->Layout();
//		sPictures->Fit(wPictures);
		imCount--;
		wPictures->SetScrollbars(button->GetSize().x+10,0,imCount,0);
		button->Destroy();
	}
	else
	{
	bcPictureDisplay *bPD;
	RECORD_ID imageId;
	((wxBitmapButton *)event.GetEventObject())->GetName().ToULong(&imageId);
	bPD=new bcPictureDisplay(this,db,table,recordId,imageId);
	bPD->Destroy();
	}
}

void bcPictures::OnDelete(wxCommandEvent &event)
{
	delMode=!delMode;
	if (delMode)
	{
		bDelete->SetLabel("View");
		SetBackgroundColour("RED");
		Refresh(TRUE);
	}
	else
	{
		bDelete->SetLabel("Delete"); 
		SetBackgroundColour(GetParent()->GetBackgroundColour());
		Refresh(TRUE);
	}
}

bcPictures::~bcPictures()
{
//clear image list
}

void bcPictures::fillPictures()
{
	QRY_ID qry;
	void *row;
	char *tmp;

	wxString tStr;
//todo - clear imagelist, picturelist
	tStr.Printf("select id from %s where parentId=%u",table.c_str(),recordId);
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{
		while (row=db->FetchRow(qry)) {
			if (tmp=db->FetchQueryResult(qry,row,0))
			{
				//fill single picture
				fillSinglePicture(atoi(tmp));
			}
		}
	db->FreeQuery(qry);
	};
}

void bcPictures::fillSinglePicture(RECORD_ID imageId)
{
	wxBitmapButton *button;
//	wxBitmap *thumb;
	
	bcPicture *img;
	img=new bcPicture(db,table,recordId,imageId);	
	img->LoadFromDatabase();
	button=new wxBitmapButton(this->wPictures,-1,img->Scale(64,64).ConvertToBitmap());
	Connect( button->GetId(),
		wxEVT_COMMAND_BUTTON_CLICKED,
		(wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction) bcPictures::OnActivate );
	wxString tStr;
	tStr.Printf("%u",imageId);	
	button->SetName(tStr);
	this->sPictures->Add(button,0,wxALIGN_CENTER|wxALL,5);
	safe_delete(img);
	sPictures->Layout();
//	sPictures->Fit(wPictures);
	imCount++;
	wPictures->SetScrollbars(button->GetSize().x+10,0,imCount,0);
	//get a thumnail
	//add to image list
	//add to lPictures
}

